/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.modifiers;

import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class VoidingModifier
extends NoLevelsModifier {
    public VoidingModifier() {
        MinecraftForge.EVENT_BUS.addListener(this::beforeBlockBreak);
        MinecraftForge.EVENT_BUS.addListener(this::onExperienceDrop);
    }

    public int getPriority() {
        return 93;
    }

    public List<ItemStack> processLoot(IToolStackView tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        generatedLoot.clear();
        return generatedLoot;
    }

    public static int boostXP(int xp, int luck) {
        float modifier = 1.0f + RANDOM.nextFloat() * (float)luck;
        return (int)(((float)xp + RANDOM.nextFloat()) * modifier);
    }

    private void beforeBlockBreak(BlockEvent.BreakEvent event) {
        ToolStack tool = VoidingModifier.getHeldTool((LivingEntity)event.getPlayer(), (InteractionHand)InteractionHand.MAIN_HAND);
        if (tool != null && tool.getModifierLevel((Modifier)this) > 0) {
            event.setExpToDrop(VoidingModifier.boostXP(event.getExpToDrop(), EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)event.getPlayer().m_21205_())));
        }
    }

    private void onExperienceDrop(LivingExperienceDropEvent event) {
        ToolStack tool = VoidingModifier.getHeldTool((LivingEntity)event.getAttackingPlayer(), (EquipmentSlot)ModifierLootingHandler.getLootingSlot((LivingEntity)event.getAttackingPlayer()));
        if (tool != null && tool.getModifierLevel((Modifier)this) > 0) {
            event.setDroppedExperience(VoidingModifier.boostXP(event.getDroppedExperience(), ModifierUtil.getLeggingsLootingLevel((LivingEntity)event.getAttackingPlayer(), (Entity)event.getEntity(), null, (int)ModifierUtil.getLootingLevel((IToolStackView)tool, (LivingEntity)event.getAttackingPlayer(), (Entity)event.getEntity(), null))));
        }
    }
}

